/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class CosmeticRemoveRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<CosmeticRemoveRecipe> SERIALIZER = new SimpleRecipeSerializer(CosmeticRemoveRecipe::new);

    public CosmeticRemoveRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundAttachable = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof ICosmeticAttachable) {
                ICosmeticAttachable attachable = (ICosmeticAttachable)item;
                if (!(stack.m_41720_() instanceof ICosmeticBauble) && !attachable.getCosmeticItem(stack).m_41619_()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundAttachable;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack attachableItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            attachableItem = stack;
        }
        ICosmeticAttachable attachable = (ICosmeticAttachable)attachableItem.m_41720_();
        if (attachable.getCosmeticItem(attachableItem).m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = attachableItem.m_41777_();
        copy.m_41764_(1);
        attachable.setCosmeticItem(copy, ItemStack.f_41583_);
        return copy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            Item patt2647$temp = s.m_41720_();
            if (patt2647$temp instanceof ItemBauble) {
                ItemBauble bauble = (ItemBauble)patt2647$temp;
                ItemStack stack = bauble.getCosmeticItem((ItemStack)s);
                stack.m_41764_(1);
                return stack;
            }
            return null;
        });
    }
}

